//浮动菜单类
class Container {
  constructor() {
    this.wrapper = document.getElementById("wrapper");
    this.second = document.getElementById("second");
    this.Roller = document.getElementsByClassName("Roller");
    this.r1 = document.getElementsByClassName("r1");
    this.r2 = document.getElementsByClassName("r2");
    this.RLayer = document.getElementById("Layer");
    this.RYuan = document.getElementById("Yuan");
    this.RCur = document.getElementById("Cur");
    //背景的三个选项
    for (let i = 0; i < this.r1.length; i++) {
        this.r1[i].onmouseover = () => {
        this.Roller[0].style.top = "-44px";
        this.Roller[0].style.transform = "translate(-50%, 0) rotate(380deg)";
        this.Roller[0].style.transformOrigin = "80px 224px";
        this.Roller[0].style.opacity = "1";
        this.Roller[1].style.top = "-44px";
        this.Roller[1].style.transform = "translate(-50%, 0) rotate(420deg)";
        this.Roller[1].style.transformOrigin = "80px 224px";
        this.Roller[1].style.opacity = "1";
        this.Roller[2].style.top = "-44px";
        this.Roller[2].style.transform = "translate(-50%, 0) rotate(460deg)";
        this.Roller[2].style.transformOrigin = "80px 224px";
        this.Roller[2].style.opacity = "1";
        document.getElementById("i3").style.background =
          "url('" + "./img/盘轨背景.png" + "')";
      };
      this.r1[i].onmouseout = () => {
        document.getElementById("i3").style.background =
          "url('" + "./img/盘轨1.png" + "')";
      };
      this.second.addEventListener("mouseover", () => {
        for (let i = 0; i < this.r1.length; i++) {
          this.Roller[i].style.top = "25px";
          this.Roller[i].style.transform = "translate(-50%, 0) rotate(0deg)";
          this.Roller[i].style.transformOrigin = "80px 205px";
          this.Roller[i].style.opacity = "0";
        }
      });
    }
    //相型的三个选项
    for (let i = 0; i < this.r2.length; i++) {
      this.r2[i].onmouseover = () => {
        this.Roller[3].style.top = "-44px";
        this.Roller[3].style.transform = "translate(-50%, 0) rotate(260deg)";
        this.Roller[3].style.transformOrigin = "80px 224px";
        this.Roller[3].style.opacity = "1";
        this.Roller[4].style.top = "-44px";
        this.Roller[4].style.transform = "translate(-50%, 0) rotate(300deg)";
        this.Roller[4].style.transformOrigin = "80px 224px";
        this.Roller[4].style.opacity = "1";
        this.Roller[5].style.top = "-44px";
        this.Roller[5].style.transform = "translate(-50%, 0) rotate(340deg)";
        this.Roller[5].style.transformOrigin = "80px 224px";
        this.Roller[5].style.opacity = "1";
        document.getElementById("i3").style.background =
          "url('" + "./img/盘轨相型.png" + "')";
      };
      this.r2[i].onmouseout = () => {
        document.getElementById("i3").style.background =
          "url('" + "./img/盘轨1.png" + "')";
      };
      this.second.addEventListener("mouseover", () => {
        for (let i = 3; i < 6; i++) {
          this.Roller[i].style.top = "25px";
          this.Roller[i].style.transform = "translate(-50%, 0) rotate(0deg)";
          this.Roller[i].style.transformOrigin = "80px 205px";
          this.Roller[i].style.opacity = "0";
        }
      });
    }
    //幕的选项
    this.RCur.onmouseover = () => {
      this.Roller[6].style.top = "-44px";
      this.Roller[6].style.transform = "translate(-50%, 0) rotate(220deg)";
      this.Roller[6].style.transformOrigin = "80px 224px";
      this.Roller[6].style.opacity = "1";
      document.getElementById("i3").style.background =
        "url('" + "./img/盘轨幕.png" + "')";
    };
    this.RCur.onmouseout = () => {
      document.getElementById("i3").style.background =
        "url('" + "./img/盘轨1.png" + "')";
    };
    this.second.addEventListener("mouseover", () => {
      this.Roller[6].style.top = "25px";
      this.Roller[6].style.transform = "translate(-50%, 0) rotate(0deg)";
      this.Roller[6].style.transformOrigin = "80px 205px";
      this.Roller[6].style.opacity = "0";
    });
    // 缘的选项
    this.RYuan.onmouseover = () => {
      document.getElementById("i3").style.background =
        "url('" + "./img/盘轨缘.png" + "')";
    };
    this.RYuan.onmouseout = () => {
      document.getElementById("i3").style.background =
        "url('" + "./img/盘轨1.png" + "')";
    };
    // 隐的选项
    this.RLayer.onmouseover = () => {
      document.getElementById("i3").style.background =
        "url('" + "./img/盘轨隐.png" + "')";
    };
    this.RLayer.onmouseout = () => {
      document.getElementById("i3").style.background =
        "url('" + "./img/盘轨1.png" + "')";
    };
    //阻止冒泡事件
    this.second.onmousedown = (event) => {
      event.stopPropagation();
      this.wrapper.style.display = "none";
    };

    //阻止冒泡事件
    this.wrapper.onmousedown = (event) => {
      event.stopPropagation();
    };
  }
}
const container = new Container();
//base64Encode数组转64字符
function base64Encode(input) {
  var rv;
  rv = encodeURIComponent(input);
  rv = unescape(rv);
  rv = window.btoa(rv);
  return rv;
}
function arrayBufferToBase64( buffer ) {
  var binary = '';
  var bytes = new Uint8Array( buffer );
  var len = bytes.byteLength;
  for (var i = 0; i < len; i++) {
      binary += String.fromCharCode( bytes[ i ] );
  }
  return window.btoa( binary );
}

//获取父元素的偏移量的方法
function GetAbsoluteXY(obj) {
  var top = obj.offsetTop;
  var left = obj.offsetLeft;
  while (obj.offsetParent) {
    top += obj.offsetParent["offsetTop"];
    left += obj.offsetParent["offsetLeft"];
    obj = obj.offsetParent;
  }
  return {
    x: left,
    y: top,
  };
}

function getXY(e, obj) {
  var et = e.touches ? e.touches[0] : e;
  var x = et.clientX;
  var y = et.clientY;
  var wapperobj = document.getElementById("wrapper");
  return {
    x:
      x -
      wapperobj.offsetLeft +
      (document.body.scrollLeft || document.documentElement.scrollLeft),
    y:
      y -
      wapperobj.offsetTop +
      (document.body.scrollTop || document.documentElement.scrollTop),
  };
}



function handleContextmenu(e) {
  // 阻止默认右键菜单
  e.preventDefault()
  e.stopPropagation()
  // console.log(e)
  //判断当前的线段关闭功能是否显示
  if(document.getElementsByClassName('drawflow-delete').length > 0){
    document.getElementById('customContextMenu').style.display = 'none';
    hideMenu()
    return
  }
  const customMenu = document.getElementById('customContextMenu');
  // 显示自定义菜单
  customMenu.style.display = 'block';

  // 获取视窗尺寸
  const windowWidth = window.innerWidth;
  const windowHeight = window.innerHeight;

  // 获取菜单尺寸
  const menuWidth = customMenu.offsetWidth;
  const menuHeight = customMenu.offsetHeight;

  // 计算菜单位置 - 确保不会超出视窗
  let posX = e.pageX;
  let posY = e.pageY;

  // 水平方向调整
  if (posX + menuWidth > windowWidth) {
    posX = windowWidth - menuWidth - 10;
  }

  // 垂直方向调整
  if (posY + menuHeight > windowHeight) {
    posY = windowHeight - menuHeight - 10;
  }

  // 设置菜单位置
  customMenu.style.left = posX + 'px';
  customMenu.style.top = posY + 'px';
}

  // var x ,y;
  // function positonXY(event) {
  //   x = event.pageX; // 水平坐标（含滚动距离）  
  //   y = event.pageY; // 垂直坐标（含滚动距离）
  //   console.log(`文档坐标：(${x}, ${y})`);
  // }


  

// 右键菜单
function rightMenu() {
    const customMenu = document.getElementById('customContextMenu');
    // const demoArea = document.getElementById('demoArea');  

    // 在文档上监听右键点击事件
    document.getElementById("drawflow").addEventListener('contextmenu',handleContextmenu);
    

    // 点击任意位置关闭菜单（菜单自身点击除外）
    document.addEventListener('click', (e) => {
      // 如果点击的不是菜单，则隐藏菜单
      if (!customMenu.contains(e.target)) {
        customMenu.style.display = 'none';
        // hideMenu()
      }
    });

    // 为菜单项添加点击事件
    const menuItems = customMenu.querySelectorAll('.menu-item');
    menuItems.forEach(item => {
      item.addEventListener('click', (event) => {
        event.stopPropagation();
        const action = item.getAttribute('data-action');
        console.log(action)
        // 根据不同的动作执行不同的操作
        switch (action) {
          case 'startCard':
            addNodeToDrawFlow_A("facebook",x,y)
            break;
          case 'eventCard':
            addNodeToDrawFlow_A("template",x,y)
            break;
          case 'conditionCard':
            addNodeToDrawFlow_A("dbclick",x,y)
            break;
          case 'conditionCard-huo':
            addNodeToDrawFlow_A("dbclick",x,y,'conditionCard-huo')
            break;
          case 'conditionCard-yu':
            addNodeToDrawFlow_A("dbclick",x,y,'conditionCard-yu')
            break;
          case 'conditionCard-fei':
            addNodeToDrawFlow_A("dbclick",x,y,'conditionCard-fei')
            break;
          case 'endCard':
            addNodeToDrawFlow_A("slack",x,y)
            break;
        }
        // 点击菜单项后隐藏菜单
        customMenu.style.display = 'none';
      });
    });

    // 阻止在菜单上右键点击时触发默认菜单
    customMenu.addEventListener('contextmenu', (e) => {
      e.preventDefault();
      e.stopPropagation();
    });
}



//圆角滑块类
class RadiusSlider {
  constructor(ArcL) {
    //ArcL计量单位 pi
    //文相Div圆角弧度大小设计
    let HalfArc = ArcL / 2,
      DrawStart = 0.5 - HalfArc / 2,
      DrawEnd = 0.5 + HalfArc / 2,
      StartArc = Math.PI * (3 / 2 - HalfArc),
      EndArc = Math.PI * (3 / 2 + HalfArc);
    this.slider = document.getElementById("canvasId");
    this.slider.ctx = this.slider.getContext("2d");
    this.slider.ox = 225;
    this.slider.oy = 225;
    this.slider.or = 220;
    this.slider.br = 8;
    this.slider.moveFlag = false;
    this.slider.offset = function offset(r, d) {
      //根据弧度与距离计算偏移坐标
      return { x: -Math.sin(r) * d, y: Math.cos(r) * d };
    };

    this.slider.Draw = (n) => {
      this.slider.ctx.clearRect(0, 0, this.slider.width, this.slider.width); //使用clearRect(x,y,width,height)在画布中清除一个矩形;参数：x，Y：要清除的矩形区域的坐标；矩形的宽和高
      this.slider.ctx.strokeStyle = "#b6b0ff";
      this.slider.ctx.lineWidth = 5;
      this.slider.ctx.beginPath();
      // this.slider.ctx.arc( this.slider.ox, this.slider.oy,this.slider.or,1.25*Math.PI,1.75*Math.PI,false);//1/4圆
      this.slider.ctx.arc(
        this.slider.ox,
        this.slider.oy,
        this.slider.or,
        StartArc,
        EndArc,
        false
      ); //2/9圆弧
      this.slider.ctx.stroke();
      this.slider.ctx.strokeStyle = "#69f";
      this.slider.ctx.lineWidth = 5;
      this.slider.ctx.beginPath();
      this.slider.ctx.arc(
        this.slider.ox,
        this.slider.oy,
        this.slider.or,
        (2 * n + 0.5) * Math.PI,
        (2 * n + 0.5) * Math.PI,
        false
      );
      this.slider.ctx.stroke();
      this.slider.ctx.fillStyle = "#69f";
      this.slider.ctx.font = "bold 18px 微软雅黑";
      // this.slider.ctx.textAlign = "center";
      this.slider.ctx.textBaseline = "middle";
      this.value = Math.round(((n - DrawStart) / HalfArc) * 100) + "%";
      if (this.onChangeCanvas) {
        this.onChangeCanvas(this.value);
      }
      this.slider.ctx.fillText(this.value, 200, 60);
      this.slider.ctx.fillStyle = "#00f";
      this.slider.ctx.beginPath();
      let d = this.slider.offset(n * 2 * Math.PI, this.slider.or);
      this.slider.ctx.arc(
        this.slider.ox + d.x,
        this.slider.oy + d.y,
        this.slider.br,
        0,
        2 * Math.PI,
        true
      ); //画圆球
      this.slider.ctx.fill();
    };
    //逆向画出对应的百分比的弧
    this.slider.DrawPer = (percent) => {
      let n = (percent.split("%")[0] / 100) * HalfArc + DrawStart;
      this.slider.Draw(n);
    };
    this.slider.addEventListener(
      on.start,
      (e) => {
        this.slider.moveFlag = true;
      },
      false
    );
    this.slider.addEventListener(
      on.move,
      (e) => {
        //判断并解决由于父div旋转带来的鼠标的坐标偏移问题
        if (this.slider.moveFlag) {
          let k = getXY(e, this.slider);
          let x1 = k.x - this.slider.ox;
          let y1 = this.slider.oy - k.y;
          let R1 = x1 * x1 + y1 * y1;
          let r1 = Math.pow(R1, 0.5);
          let deg = Math.asin(y1 / r1);
          let Deg = (Math.PI / 180) * 100;
          let Sumdeg = deg + Deg;
          let X = r1 * Math.cos(Sumdeg);
          let Y = r1 * Math.sin(Sumdeg);
          let r = Math.atan2(X, Y);
          let hd = (Math.PI + r) / (2 * Math.PI);
          // 半圆的滑动范围判断
          if (hd <= DrawEnd && hd >= DrawStart) {
            this.slider.Draw(hd);
          }
        }
      },
      false
    );
    this.slider.addEventListener(
      on.end,
      (e) => {
        this.slider.moveFlag = false;
      },
      false
    );
    this.onChangeCanvas = null;
    this.slider.Draw(DrawStart);
  }
}

//控制器类
class Controller {
  constructor() {
    this.editState = false;
    this.menuTarget = null;
    this.RadiusSlider = new RadiusSlider(1 / 5);
    this.opacitySlider = null;
    this.HotKeyEvent=null;
    this.CreatStatus=false;
    this.moveStatus=false;
    this.History=[];//撤销操作存放历史数据
    this.PhenomenaObj=[];//用于存储相型对象的数组
    this.Recovery=[];//恢复操作存放数据
    //1.点击开始创建
    this.start();
    //2.鼠标抬起div创建完成
    this.createFinish();
    //3.菜单控制事件集合
    this.menuEvent();
    //4.定义拖出的div的背景图片选择
    this.selectImgFile();
    //5.隐进度条
    this.LayerSlider();
    //6.幕的选中功能s
    this.curtain();
    //7.全屏功能
    this.fullScreen();
    //点击菜单的音相按钮创建音相对象
    this.clickAudio();
    //点击菜单的文相按钮创建文相对象
    this.clickTexer();
    //点击菜单的视相按钮创建视相对象
    this.clickVision();
    //ctrl+Z或ctrl+Y撤销和恢复快捷键
    this.hotkeys();
    //时间轴函数
    // this.timerHandle();
    this.Timer=new Timer(30,this)
  }
  //注册热键
  hotkeys(){
    //撤销事件
     this.RevokeEvent=new HotKeyHandler(0,'Z',()=>{
       if(this.History.length==0){  //判断撤销数组中有没有数据
       return;
       }
     let lastAction=this.History.pop();
     if(this.History.length==0)this.editState = false;//如果History数组中的历史记录已经取空，则把编辑状态置false，然后返回
     switch(lastAction.OpType){
       case "create":
     this.PhenomenaObj[lastAction.Action.Id].Remove('R');
        break;
        case 'remove':
        //  document.body.appendChild(lastAction.Action.Div);//lastAction.Action=this(父相).Div==this.Div
         lastAction.Action.Pivot.Resurgence()
         this.Recovery.push({
          OpType: 'create',
          Action:  JsonClone(lastAction.Action),
           })
         break;
         case 'transform':
           for (let index = this.History.length-1; index>=0 ; index--) {//反向遍历
            //
             if(lastAction.Action.Id==this.History[index].Action.Id){
               let tempKey=JsonClone(lastAction.Key);//最后的记录对象
              //  console.log(tempKey)
              lastAction=JsonClone(this.History[index]);
              lastAction.Key=tempKey;
              break;
             }
           }
          switch(lastAction.Key){
           case "move":
             this.PhenomenaObj[lastAction.Action.Id].RcordTransform('move',"R");
            //  this.PhenomenaObj[lastAction.Action.Id].Div.style.left=lastAction.Action.XY.X+"px";
            //  this.PhenomenaObj[lastAction.Action.Id].Div.style.top=lastAction.Action.XY.Y+"px";
            //  this.PhenomenaObj[lastAction.Action.Id].XY=lastAction.Action.XY;//克隆的对象的原来记录值
             this.PhenomenaObj[lastAction.Action.Id].Sync_XY(lastAction.Action.XY);
             break; 
            case "resize":
              this.PhenomenaObj[lastAction.Action.Id].RcordTransform('resize',"R");
              this.PhenomenaObj[lastAction.Action.Id].WH=lastAction.Action.WH;
              switch(this.PhenomenaObj[lastAction.Action.Id].constructor){
                case Texter:
                this.PhenomenaObj[lastAction.Action.Id].textareaT(lastAction.Action.WH);
                break
                case Voicer:
                this.PhenomenaObj[lastAction.Action.Id].APlayerDivT();
                break
                case Vision:
                this.PhenomenaObj[lastAction.Action.Id].DPlayerDivT();
                break;
              }
            break;
            case "opacity":
              console.log(111222)
             this.PhenomenaObj[lastAction.Action.Id].RcordTransform("opacity",'R');
             this.PhenomenaObj[lastAction.Action.Id].SetOpacity(lastAction.Action.Opacity);
             break;
             case "caption":
             this.PhenomenaObj[lastAction.Action.Id].RcordTransform("caption",'R');
             this.PhenomenaObj[lastAction.Action.Id].content=lastAction.Action.content;
             this.PhenomenaObj[lastAction.Action.Id].textFadeIn();
            //  console.log("历史记录：",this.History)
            //  console.log("恢复数据：",this.Recovery);
             break;
            case "Bgurl":
            this.PhenomenaObj[lastAction.Action.Id].RcordTransform('Bgurl','R');
            this.PhenomenaObj[lastAction.Action.Id].SetBackground(lastAction.Action.BgUrl,lastAction.Action.Div.BgColor)
            console.log(lastAction.Action.BgUrl);
            console.log("历史记录：",this.History);
            break;
          }
          break;
     }
  })
  //恢复事件
    this.RecoveryEvent=new HotKeyHandler(2,'Z',()=>{
      if(this.Recovery.length==0){//判断恢复数组中有没有数据
        return;
        }
      let lastAction=this.Recovery.pop();
      switch(lastAction.OpType){
        case "create":
      this.PhenomenaObj[lastAction.Action.Id].Remove();
         break;
         case 'remove':
          document.body.appendChild(lastAction.Action.Div);
          this.History.push(
            {
           OpType: 'create',
           Action:  JsonClone(lastAction.Action),
            }
          )
          break;
        case 'transform':
         switch(lastAction.Key){
          case "move":
            this.PhenomenaObj[lastAction.Action.Id].RcordTransform('move');//this.phenomenaObj为原型对象，lastAction.Action.Id为复刻的对象
            this.PhenomenaObj[lastAction.Action.Id].Div.style.left=lastAction.Action.XY.X+"px";
            this.PhenomenaObj[lastAction.Action.Id].Div.style.top=lastAction.Action.XY.Y+"px";
            this.PhenomenaObj[lastAction.Action.Id].XY=lastAction.Action.XY;
            break; 
            case "resize":
              this.PhenomenaObj[lastAction.Action.Id].RcordTransform('resize');
              this.PhenomenaObj[lastAction.Action.Id].WH=lastAction.Action.WH;
              switch(this.PhenomenaObj[lastAction.Action.Id].constructor){
                case Texter:
                this.PhenomenaObj[lastAction.Action.Id].textareaT(lastAction.Action.WH);
                break
                case Voicer:
                this.PhenomenaObj[lastAction.Action.Id].APlayerDivT();
                break
                case Vision:
                this.PhenomenaObj[lastAction.Action.Id].DPlayerDivT();
                break;
              }
            break;
            case "opacity":
              // 此处出现bug,操作后记录，应该先恢复赋值，再记录，否则数据错位！
             this.PhenomenaObj[lastAction.Action.Id].SetOpacity(lastAction.Action.Opacity);
             this.PhenomenaObj[lastAction.Action.Id].RcordTransform("opacity");
             break;
             case "caption":
              // 此处出现bug,操作后记录，应该先恢复赋值，再记录，否则数据错位！
             this.PhenomenaObj[lastAction.Action.Id].content=lastAction.Action.content;
             this.PhenomenaObj[lastAction.Action.Id].RcordTransform("caption");
             this.PhenomenaObj[lastAction.Action.Id].textFadeIn();
            //  console.log("历史数据：",this.History);
            //  console.log("恢复数据：",this.Recovery);
             break; 
            case "Bgurl":
            this.PhenomenaObj[lastAction.Action.Id].SetBackground(lastAction.Action.BgUrl,lastAction.Action.Div.BgColor);
            this.PhenomenaObj[lastAction.Action.Id].RcordTransform('Bgurl');
            console.log("历史记录：",this.History);
            console.log("恢复数据：",this.Recovery);
            break;
         }
      }
   })
  }
  start() {
    document.oncontextmenu = () => false; //oncontextmenu事件，屏蔽鼠标右键菜单
    document[on.Start] = (event) => {

      // event=event.pageX?event:event.targetTouches[0]
      event=CoordinatE(event)
      this.XY = {
        X: event.pageX,
        Y: event.pageY,
      };
      // window.pageX = event.pageX
      // window.pageY = event.pageY
      // console.log(event.pageX,event.pageY)
      if (this.editState) return; //如果是编辑状态则退出--->this.phenomenaObj.length为实例化对象的Div的id
      const C = new Texter(this.PhenomenaObj.length,JsonClone(this.XY),null,null,null,"#"+ColorToolKit.HsbToHex({h:Math.round(Math.random()*360),s:Math.round(Math.random()*69),b:Math.round(70+Math.random()*30)}));
      this.CreatStatus=true;
      this.menuTarget=C
      // this.PhenomenaObj.push(C);//把拖拽完成的相存入相型数组中
      document[on.Move] = (event) => {
        event=CoordinatE(event)
          // event=event.pageX?event:event.targetTouches[0]
        C.DrawDiv(event,this.XY);
      };
    };
  }
  //点击菜单的音相按钮执行父相里的切换到音相的方法
  clickAudio() {
    let Vio = document.getElementById("viocer");
    Vio.onclick = (ev) => {
      this.menuTarget.ToVoicer();
    };
  }
  //点击菜单的文相按钮执行父相里的切换到文相的方法
  clickTexer(){
    let Vio = document.getElementById("Texter");
    Vio.onclick = (ev) => {
      this.menuTarget.ToTexter();
    };
  }
  //点击菜单的视相按钮，生成视相对象
  clickVision() {
    let Video = document.getElementById("Vision");
    Video.onclick = (ev) => {
      this.menuTarget.ToVision();
    };
  }
  //拾色器的调用
  colorful() {
    Colorpicker.create({
      el: "cp",
      color: this.menuTarget.Div.BgColor,
      clickfun: () => {
        this.menuTarget.Div.style.background = null;
        this.menuTarget.Div.style.background=this.menuTarget.Div.BgColor;
      },
      change: (elem, hex) => {
        this.menuTarget.Div.style.backgroundColor = hex;
        this.menuTarget.Div.BgColor=hex;
        this.menuTarget.RcordTransform("Bgcolor");
      },
    });
  }
  //隐进度条
  LayerSlider() {
    let rotater = document.getElementById("Layer");
    let InputRage = document.createElement("input");
    InputRage.className = "sliderRage";
    InputRage.type = "range";
    InputRage.min = "0";
    InputRage.max = "100";
    InputRage.value = "0";
    InputRage.visible = true;
    rotater.appendChild(InputRage);
    this.opacitySlider = InputRage;
    let valSpan = document.createElement("span");
    rotater.appendChild(valSpan);
    InputRage.oninput = () => {
      valSpan.innerText = InputRage.value + "%";
      this.menuTarget.SetOpacity(1-InputRage.value/100);//此處為指定Div的隱設置值
      InputRage.style.background ="linear-gradient(to right, #059CFA, white " +InputRage.value +"%, white)";
    };
    InputRage.onmouseup=()=>{
      this.menuTarget.RcordTransform("opacity");
      // console.log(this.History);
    }
  }
  // 定义菜单控制事件
  menuEvent() {
    // 通过Id获取归墟按钮的div并为它绑定一个鼠标下压事件用于删除对应的拖出来的div
    document.getElementById("second").onmousedown = (evnt) => {
     this.menuTarget.Remove();
      document.getElementById("wrapper").style.display = "none";
    };
  }
  //Div创建完成,先置空onmousemove事件
  createFinish() {
    window[on.End]=() => {
      document[on.Move] = null;
      if(this.CreatStatus){
        this.CreatStatus=false;
        this.menuTarget.Div.BgColor="#"+this.menuTarget.hex;
        // Div拖拽完成后为History数组添加一条Json数据对象{Optype:"create"，Action：JsonClone(this.menuTarget)}---->optype操作类型，action执行的动作
        if(this.menuTarget.WH.W==0||this.menuTarget.WH.H==0){
          removeElement(this.menuTarget.Div);
          return;
        }
        this.History.push({
          OpType:"create",
          Action: JsonClone(this.menuTarget),
        })
        this.Timer.appendPivot(this.menuTarget)
      }if(this.moveStatus){
       this.menuTarget.RcordTransform("move");
       console.log(this.History)
       this.moveStatus=false;
        //记录div移动后的位置信息
      }
    }
  }
  // 定义了一个更换背景图片的函数
  selectImgFile() {
    //  获取input的元素对象，获取图片按钮的对象，并为它绑定一个单击事件用于上传背景图片
    var inp = document.getElementById("inp");
    var RollerImg = document.getElementsByClassName("Roller")[0];
    RollerImg.onclick = function () {
      inp.click();
    };
    /*   为input对象绑定一个onchange触发事件；当背景图片选择后，文件对象读取到对应的已选文件对象时获取该文件的虚拟路径，
     *    并将其转换为实际的路径；并将该路径保存到变量imagUrl中，获取创建的div对象，将背景图片的路径赋值给它的background的url，
     *    this.menuTarget.Div.style.backgroundSize="100% 100%" 背景图片样式实现伸缩。
     */
    inp.onchange = (e) => {
      var reader = new FileReader();
      reader.onload = (evt) => {
        var imageUrl = evt.target.result;
        this.menuTarget.BgUrl=imageUrl;//将图片的url赋值给父相的属性Bgurl
        this.menuTarget.RcordTransform("Bgurl");//此处调用父相的方法记录父相的操作记录
        this.menuTarget.Div.style.backgroundColor='transparent';
        this.menuTarget.Div.style.backgroundImage = "url('" + imageUrl + "')";
      };
      reader.readAsDataURL(inp.files[0]);
      this.menuTarget.Div.style.backgroundSize = "100% 100%";
      inp.value='';
    };
  }
  //幕的选择元素的事件的定义
  curtain() {
    let rotater = document.querySelector("#curtianOp");
    rotater.onclick = () => {
      this.menuTarget.Curtain = !this.menuTarget.Curtain;
    };
  }
  //全屏功能
  fullScreen() {
    let fullScr = document.getElementById("fullOp");
    fullScr.onmouseup = () => {
      this.menuTarget.fullscreen = !this.menuTarget.fullscreen;
      if (this.menuTarget.fullscreen === true) {
        this.menuTarget.Div.style.top = "0px";
        this.menuTarget.Div.style.left = "0px";
        this.menuTarget.Div.style.width = "100%";
        this.menuTarget.Div.style.height = "100%";
        if(this.menuTarget.constructor==Vision){
          this.menuTarget.VideoDiv.style.top = "0px";
          this.menuTarget.VideoDiv.style.left = "0px";
          this.menuTarget.VideoDiv.style.width = "100%";
          this.menuTarget.VideoDiv.style.height = "100%";
        }
      } else {
        this.menuTarget.Div.style.top = this.menuTarget.XY.Y + "px";
        this.menuTarget.Div.style.left = this.menuTarget.XY.X + "px";
        this.menuTarget.Div.style.width = this.menuTarget.WH.W + "px";
        this.menuTarget.Div.style.height = this.menuTarget.WH.H + "px";
        if(this.menuTarget.constructor==Vision){
          this.menuTarget.VideoDiv.style.top = 0 + "px";
          this.menuTarget.VideoDiv.style.left = 0 + "px";
          this.menuTarget.VideoDiv.style.width = this.menuTarget.WH.W + "px";
          this.menuTarget.VideoDiv.style.height = this.menuTarget.WH.H+ "px";
        }
      }

    };
  }
//  timerHandle(){}


}
let WZCContorller = new Controller();
//父相类
class ClassPhenomena {
  constructor(
    Id,
    XY,
    WH,
    Opacity,
    BgUrl,
    BgColor,
    Curtain,
    Radius,
    fullscreen,
    OnToolbarDraw
  ) {
    WZCContorller.PhenomenaObj[Id]=this;//往控制器定义的原型相数组中通过Id下标添加对象
    this.Id=Id;
    this.menuDiv = null;
    this.textarea = null;
    this.editing = false;
    this.Curtain = Curtain || false;
    this.fullscreen = fullscreen || false;
    this.Div = document.createElement("div");
    this.Div.className = "Div"; //设置样式
    this.Div.id = "DivID";
    this.Div.BgColor=BgColor|| "#87ceeb";
    this.Div.style.backgroundColor = this.Div.BgColor;
    this.BgUrl=BgUrl  ||null;
    this.Div.style.backgroundImage = BgUrl || "";
    this.Div.style.top = XY.Y + "px";
    this.Div.style.left = XY.X + "px";
    this.XY = XY;
    this.SetOpacity(Opacity|1); //透明度--->隐
    this.Radius = Radius || "0";
    this.Ignores=['Pivot'];
    //用于存储动态拖出来的div的宽高
    this.WH = WH || { W: 0, H: 0 };
    this.Div.style.width = this.WH.W + "px";
    this.Div.style.height = this.WH.H + "px";
    φ("#Scene").appendChild(this.Div);
    this.Div.style.position = "absolute";
    this.Div.style.overflow = "hidden";
    this.OnToolbarDraw = OnToolbarDraw || false;
    // 点击拖动div 1.按下事件
    this.Div.addEventListener(on.start, (e) =>{
      // if(WZCContorller.moveStatus)return 
      WZCContorller.menuTarget = this;
      if (this.Curtain === false) {
        e.stopPropagation();
        //e.offesetX和e.offsetY相对于带有定位的父盒子的x，y坐标
        e=CoordinatE(e)
        
        let offsetX = e.pageX-this.XY.X;
        let offsetY = e.pageY-this.XY.Y; //解决火狐浏览器不兼容问题
        // let Rx= e.pageX,Ry=e.pageY;
        // console.log(this.XY)
        //2.移动事件
        document[on.Move] = (ev) => {
          ev=CoordinatE(ev)
          // console.log(ev)
          // console.log(offsetX,ev.pageX,Rx,ev.pageX - offsetX)
          let x = ev.pageX - offsetX;//ev.pageX和ev.pageY对于整个页面来言，包括了被卷去的body部分的坐标
          let y = ev.pageY - offsetY;
          // let x =ev.pageX-Rx ;//ev.pageX和ev.pageY对于整个页面来言，包括了被卷去的body部分的坐标
          // let y =ev.pageY-Ry ;
          // console.log(x,y)
          if(Math.abs(this.XY.X-x)<=1 && Math.abs(this.XY.Y-y)<=1){
            return;//如果Div的宽高为0，则页面不显示
          }
          WZCContorller.moveStatus=true;
          if (x < 0) {//div避免左边区域拖出界
            x = 0;
          } 
          else if ( x > document.documentElement.clientWidth - this.Div["offsetWidth"]) //div不能右边区域拖出界
          {
            x = document.documentElement.clientWidth - this.Div["offsetWidth"];
          }
          if (y < 0) {
            y = 0;//div顶部不出界
          } else if (
            y > document.documentElement.clientHeight - this.Div["offsetHeight"]
          ) {
            y = document.documentElement.clientHeight - this.Div["offsetHeight"];//div底部不拖出界
          }

          //给垂直方向补差值
          if (this.OnToolbarDraw) {
            // this.Div["style"].top = y + 35 + "px";
            this.Div["style"].top = y + "px";
            // console.log('Should OverView')
          } else {
            this.Div["style"].top = y + "px";
          }
          //给水平方向补差值
          if (this.constructor == Texter) {
            if (
              this.menuDiv && this.menuDiv.offsetWidth > this.textarea.offsetWidth
            ) {
              // this.Div["style"].left =
              //   x +(this.menuDiv.offsetWidth - this.textarea.offsetWidth) / 2 +"px";
                this.Div["style"].left = x + "px";
            } else {
              this.Div["style"].left = x + "px";
            }
          }
          if (this.constructor == Voicer||this.constructor==Vision) {
            if (
              this.Div &&
              this.OnToolbarDraw &&
              this.menuDiv.offsetWidth > this.Div.offsetWidth
            ) {
              this.Div["style"].left =
                x +
                (this.menuDiv.offsetWidth - this.Div.offsetWidth) / 2 +
                "px";
            } else {
              this.Div["style"].left = x + "px";
            }
          }
          this.XY = {
            X: Number(this.Div["style"].left.split("px")[0]),
            Y: Number(this.Div["style"].top.split("px")[0]),
          };
         
          // console.log(this.XY)
          if(this.AudioWrapper){
          this.AudioWrapper.style.left=this.XY.X+"px";
          this.AudioWrapper.style.top=this.XY.Y+"px";
          };
          if(this.VideoWrapper){
            this.VideoWrapper.style.left=this.XY.X+"px";
            this.VideoWrapper.style.top=this.XY.Y+"px";
            }
        };
      } else {
        //当幕的checkbox被选中时，对应div不能拖动。
        this.Div[on.Move] = null;
        document[on.Move] = null;
        return;
      }
    });
    // Div 右击事件
    this.Div.oncontextmenu = (event) => {
      event.preventDefault();
      event.stopPropagation();
      if(WZCContorller.editState){
        return;
      }
      this.ToggleColor();
      let x = event.pageX;
      let y = event.pageY;
      this.wrapper = document.getElementById("wrapper");
      this.i1 = document.getElementsByClassName("i1")[0];
      this.wrapper.style.cssText = "width:450px;height:450px;display:block";
      this.wrapper.style.left = x - 225 + "px";
      this.wrapper.style.top = y - 225 + "px";
      let ColorPancel=document.getElementById("IPanel");
      if(ColorPancel){
        removeElement(ColorPancel.parentNode);
      }
      WZCContorller.colorful(); //此处调用了调色板函数
      this.wrapper.oncontextmenu = (event) => {
        event.preventDefault();
      };
      //设置菜单上的幕与div对应的状态同步
      document.querySelector("#curtianchb").checked = this.Curtain;
      //设置菜单上全屏选项与div对应的状态同步
      document.querySelector("#fullcheck").checked = this.fullscreen;
      //给拖拽出来的div透明度赋初值
      WZCContorller.opacitySlider.value = 100 - 100 * this.Div.style.opacity;
      WZCContorller.opacitySlider.oninput();
      //右击滑动条div圆角设置
      WZCContorller.RadiusSlider.onChangeCanvas = (val) => {
        this.Div.style.borderRadius = val;
        this.Radius = val;
      };
      //此处调用圆角滑块类的DrawPer()，逆向画出对应的百分比弧，使得滑动条同步上一次编辑状态
      WZCContorller.RadiusSlider.slider.DrawPer(this.Radius);
      this.wrapper.onmouseleave = () => {
        this.wrapper.style.display = "none";
        WZCContorller.RadiusSlider.slider.moveFlag = false;
        this.leave();
      };
      this.i1.onclick = () => {
        this.wrapper.style.display = "none";
        this.leave();
      };
    };
  }
  // 设置相的隐的值
  SetOpacity(opacity){
   this.Div.style.opacity=opacity;
   this.Opacity=opacity;

  }
  RcordTransform(Key,recordTyp){
    if(recordTyp=='R'){
      WZCContorller.Recovery.push({
       OpType:"transform",
       Key:Key,
       Action:JsonClone(this),  }
      );
     }else{
       WZCContorller.History.push({
         OpType:"transform",
         Key:Key,
         Action: JsonClone(this),
       })
     }
  }
  Remove(recordTyp){
    removeElement(this.Div);
    this.Pivot.Remove()
    if(this.AudioWrapper){
        removeElement(this.AudioWrapper);
      }
      if(this.VideoWrapper){
        removeElement(this.VideoWrapper);
      }
    if(recordTyp=='R'){
     WZCContorller.Recovery.push({
      OpType:"remove",
      Action: this,
     }
     )
    }else{
      WZCContorller.History.push({
        OpType:"remove",
        Action: this,
      })
    }
  }
 SetBackground(BgUrl,BgColor){
   this.BgUrl=BgUrl;
   this.BgColor=BgColor;
  if(BgUrl){
    this.Div.style.backgroundColor='transparent';
    this.Div.style.backgroundImage="url('" +BgUrl+ "')";
  }else{
   this.Div.style.backgroundColor=BgColor;
   this.Div.style.backgroundImage=null;
  }
  }
  ToggleColor(){
    φ('#Texter').style.filter='';
    φ('#viocer').style.filter='';
    φ('#Vision').style.filter='';
    switch(this.constructor){
      case Texter :
        φ('#Texter').style.filter='hue-rotate(342deg) saturate(3.5)';
        break;
      case Voicer:
        φ("#viocer").style.filter='hue-rotate(342deg) saturate(3.5)';
        break;
      case Vision:
        φ("#Vision").style.filter='hue-rotate(342deg) saturate(3.5)';
        break;
    }
  }
  DrawBgColor(dXY){//from distance of original spawn arc compute hue of Div BgColor dynamical
    let NowHSB= ColorToolKit.hexToHsb(this.Div.BgColor)
    NowHSB.h=Math.round(NowHSB.h+(Math.atan2(dXY.X,dXY.Y)/Math.PI+Math.PI)*180)%360;
    let RGB =ColorToolKit.HSBToRGB(NowHSB)
    this.rgb=RGB
    this.Div.style.backgroundColor=`rgb(${RGB.r},${RGB.g},${RGB.b})`
    this.hex=ColorToolKit.rgbToHex(RGB)
  }
  //动态确定div大小
  DrawDiv(e, XY) {
    //动态的确定div的宽高
    this.DrawDiv_WH(e, XY);
    //象限的位置关系
    if (e.clientX - XY.X > 0 && e.clientY - XY.Y < 0) {
      this.Div.style.top = e.clientY + "px";
      this.Div.style.left = XY.X + "px";
    } else if (e.clientX - XY.X < 0 && e.clientY - XY.Y < 0) {
      this.Div.style.top = e.clientY + "px";
      this.Div.style.left = e.clientX + "px";
    } else if (e.clientX - XY.X < 0 && e.clientY - XY.Y > 0) {
      this.Div.style.left = e.clientX + "px";
      this.Div.style.top = XY.Y + "px";
    } else {
      this.Div.style.top = XY.Y + "px";
      this.Div.style.left = XY.X + "px";
    }
    this.DrawBgColor({
      X:e.pageX-XY.X,
      Y:e.pageY-XY.Y
    })
    this.XY.X=Number(this.Div.style.left.split('px')[0]);
    this.XY.Y=Number(this.Div.style.top.split('px')[0]);
  }

  DrawDiv_WH(e, XY) {
    //动态的确定div的宽高
    this.WH.W = Math.abs(e.pageX - XY.X);
    this.WH.H = Math.abs(e.pageY - XY.Y);
    this.Div.style.width = this.WH.W + "px";
    this.Div.style.height = this.WH.H + "px";
    if(this.AudioWrapper){
      this.AudioWrapper.style.width= this.WH.W+'px';
      this.AudioWrapper.style.height= this.WH.H+'px';
    }
    if(this.VideoWrapper){
      this.VideoWrapper.style.width= this.WH.W+'px';
      this.VideoWrapper.style.height= this.WH.H+'px';
    }
    if(this.VideoDiv){
      this.VideoDiv.style.width= this.WH.W+'px';
      this.VideoDiv.style.height= this.WH.H+'px';
    }
  }
  leave() {
    //退出时,旋转的位置恢复原样
    this.Roller = document.getElementsByClassName("Roller");
    for (let i = 0; i < 6; i++) {
      this.Roller[i].style.top = "25px";
      this.Roller[i].style.transform = "translate(-50%, 0) rotate(0deg)";
      this.Roller[i].style.transformOrigin = "80px 205px";
      this.Roller[i].style.opacity = "0";
    }
   
  }
  //删除拖拽出来的文相div,创建一个音相实例化对象，实现文相到音相的切换
  ToVoicer() {
    if(this.AudioWrapper){
      removeElement(this.AudioWrapper);
    }
    if(this.VideoWrapper){
      removeElement(this.VideoWrapper);
    }
    let abandonDiv = this.Div;
    let NewVoicer = new Voicer(
      this.Id,
      this.XY,
      this.WH,
      this.Div.style.opacity,
      this.Div.style.backgroundImage,
      this.Div.BgColor,
      this.Curtain,
      this.Radius,
      this.fullscreen
    );
    WZCContorller.menuTarget=NewVoicer;
    removeElement(abandonDiv);
    NewVoicer.ToggleColor();
  }
  //从音相切换到文相
  ToTexter(){
    if(this.AudioWrapper){
      removeElement(this.AudioWrapper);
    }
    if(this.VideoWrapper){
      removeElement(this.VideoWrapper);
    }
    let abandonDiv = this.Div;
    let NewTexter = new Texter(
      this.Id,
      this.XY,
      this.WH,
      this.Div.style.opacity,
      this.Div.style.backgroundImage,
      this.Div.BgColor,
      this.Curtain,
      this.Radius,
      this.fullscrseen
    );
    WZCContorller.menuTarget=NewTexter;
    removeElement(abandonDiv);
    NewTexter.ToggleColor();
  }

  //从文相切换到视相
  ToVision(){
    if(this.AudioWrapper){
      removeElement(this.AudioWrapper);
    }
    if(this.VideoWrapper){
      removeElement(this.VideoWrapper);
    }
    let abandonDiv = this.Div;
    let NewVision = new Vision(
      this.Id,
      this.XY,
      this.WH,
      this.Div.style.opacity,
      this.Div.style.backgroundImage,
      this.Div.BgColor,
      this.Curtain,
      this.Radius,
      this.fullscreen
    );
    WZCContorller.menuTarget=NewVision;
    removeElement(abandonDiv);
    NewVision.ToggleColor();
  }
  Sync_XY(XY){
    this.XY=JsonClone(XY);
    this.Div.style.left=this.XY.X+"px";
    this.Div.style.top=this.XY.Y+"px";
  }
}

//文相类部分
class Texter extends ClassPhenomena {
  constructor(
    Id,
    XY,
    WH,
    Opacity,
    BgUrl,
    BgColor,
    Curtain,
    Radius,
    fullscreen,
    OnToolbarDraw
  ) {
    super(
      Id,
      XY,
      WH,
      Opacity,
      BgUrl,
      BgColor,
      Curtain,
      Radius,
      fullscreen,
      OnToolbarDraw
    );
    this.DivSon = document.createElement("div");
    this.DivSon.className = "DivSon";
    this.DivSon.style.float = "left"; //设置样式
    this.DivSon.style.fontFamily = this.selectValue;
    this.Div.appendChild(this.DivSon);
    this.content = "";
    this.selectValue = "宋体";
    this.flag = true;
    let menuTimer;
    this.textCenter = false;
    //文字颜色 & 文字大小 &  字幕速度 & 光标速度
    this.textColor = "#000000";
    this.textFont = "16";
    this.textSpeed = 300;
    this.cursorSpeed = 500;
    //双击div开始进入编辑状态
    // -----------进入编辑状态------------ //
    this.Div.ondblclick = (e) => {
      this.Div.style.overflow="visible";
      this.DivSon.style.display = "none";
      this.editing = true;
      if (WZCContorller.editState) {
        WZCContorller.editState.ExitEdit(e);
      }
      WZCContorller.editState = this; // 状态判断  上一个是否创建
      this.DivSon.innerHTML = "";
      //在文本域中让创建div事件失效以及重复进入时,定时器失去效用-->
      clearInterval(this.txttimer);
      clearInterval(this.flags);
      clearInterval(this.pointertimer);
      clearInterval(menuTimer);
      /* -------------------创建文本域---------------------------*/
      this.textarea = document.createElement("textarea");
      this.textarea.className = "textarea";
      this.textarea.style.width = this.Div.style.width;
      this.textarea.style.height = this.Div.style.height;
      this.textarea.style.backgroundColor=this.Div.style.backgroundColor;
      this.textarea.style.outline = "none";
      this.textarea.style.fontFamily = this.selectValue;
      this.Div.appendChild(this.textarea);
      this.textarea.value = this.content;
      this.textarea.focus();
      //  ------------------创建菜单------------------- //
      this.menuDiv = document.createElement("div");
      this.menuDiv.id = "menu";
      this.menuDiv.className = "menuDiv";
      this.menuDiv.style.width = this.textarea.offsetWidth + "px";
      //----------------创建菜单子选项 并且添加至菜单中  菜单添加至div中-------------- friction//
      const option1 = document.createElement("span"); //字体颜色
      const Picker = document.createElement("span"); //拾色器
      const option2 = document.createElement("span"); //字体大小
      const option3 = document.createElement("span"); //字幕速度
      const option4 = document.createElement("span"); //文本样式
      const option5 = document.createElement("span"); //光标速度
      const option6 = document.createElement("span"); //文本居中
      this.menuDiv.appendChild(option1);
      this.menuDiv.appendChild(option2);
      this.menuDiv.appendChild(option3);
      this.menuDiv.appendChild(option4);
      this.menuDiv.appendChild(option5);
      this.menuDiv.appendChild(option6);
      this.Div.appendChild(this.menuDiv);
      option1.className = "opt";
      option2.className = "opt";
      option3.className = "opt";
      option4.className = "opt";
      option5.className = "opt";
      option6.className = "opt";
      option6.id = "opt6";
      //文本滑块组 ===> 字体颜色模块
      option1.innerHTML = "字体颜色 ";
      option1.id = "opt1";
      option1.className = "opt1";
      option1.appendChild(Picker);
      Picker.id = "color-picker";
      Picker.className = "picker";
      //文本滑块组 ===> 字体大小模块
      option2.innerHTML = "字体大小 ";
      this.fontTs = new textSlider(this.textFont, option2);
      this.fontTs.sliderInputFuc = (self) => {
        this.textFont = self.textInput.value;
        this.textarea.style.fontSize = this.textFont + "px";
        this.DivSon.style.fontSize = this.textFont + "px";
      };
      this.fontTs.textInputFuc = () => {
        this.OnToolbarDraw = true;
      };
      const PX = document.createElement("strong");
      PX.innerHTML = " px";
      option2.appendChild(PX);
      //文本滑块类 ===> 字幕速度模块
      option3.innerHTML = "字幕速度 ";
      this.textSpeeds = new textSlider(this.textSpeed, option3);
      this.textSpeeds.sliderInputFuc = (self) => {
        this.textSpeed = self.textInput.value;
      };
      this.textSpeeds.textInputFuc = () => {
        this.OnToolbarDraw = true;
      };
      const testMS = document.createElement("strong");
      testMS.innerHTML = " ms";
      option3.appendChild(testMS);
      //文本滑块类 ===> 文本样式模块
      option4.innerHTML = "文本样式 ";
      this.selectDiv = document.createElement("div");
      this.select = document.createElement("select");
      const options1 = document.createElement("option");
      const options2 = document.createElement("option");
      const options3 = document.createElement("option");
      const options4 = document.createElement("option");
      const options5 = document.createElement("option");
      const options6 = document.createElement("option");
      options1.text = "宋体";
      options2.text = "华文新魏";
      options3.text = "华文彩云";
      options4.text = "幼圆";
      options5.text = "隶书";
      options6.text = "仿宋";
      this.select.appendChild(options1);
      this.select.appendChild(options2);
      this.select.appendChild(options3);
      this.select.appendChild(options4);
      this.select.appendChild(options5);
      this.select.appendChild(options6);
      this.selectDiv.appendChild(this.select);
      this.select.style.display = "block";
      this.select.style.marginTop = "3px";
      this.selectDiv.style.position = "absolute";
      this.selectDiv.style.top = "3px";
      this.selectDiv.style.left = "75px";
      this.selectDiv.style.display = "inline-block";
      option4.appendChild(this.selectDiv);
      this.select.value = this.selectValue;
      //文本滑块类 ===> 光标速度模块;
      option5.innerHTML = "光标速度 ";
      this.cursorSpeeds = new textSlider(this.cursorSpeed, option5);
      this.cursorSpeeds.sliderInputFuc = (self) => {
        this.cursorSpeed = self.textInput.value;
      };
      this.cursorSpeeds.textInputFuc = () => {
        this.OnToolbarDraw = true;
      };
      const cursorMS = document.createElement("strong");
      cursorMS.innerHTML = " ms";
      option5.appendChild(cursorMS);
      //文本滑块组 ===> 文本居中模块
      option6.innerHTML = "文本居中 ";
      this.inputCheckbox = document.createElement("input");
      this.inputCheckbox.type = "checkbox";
      this.inputCheckbox.style.cssText =
        "position:absolute;top:6px;left:72px;width:15px;height:15px;";
      this.inputCheckbox.id = "checkbox";
      option6.appendChild(this.inputCheckbox);
      this.inputCheckbox.onchange = (event) => {
        if (event.target["checked"] === true) {
          this.textCenter = true;
          this.textarea.style.textAlign = "center";
        } else {
          this.textCenter = false;
          this.textarea.style.textAlign = "left";
        }
      };
      if (this.textCenter) {
        this.inputCheckbox.checked = true;
        this.textarea.style.textAlign = "center";
      } else {
        this.inputCheckbox.checked = false;
        this.textarea.style.textAlign = "left";
      }
      Picker.onmousemove = (e) => {
        e.stopPropagation();
      };
      Picker.style.cssText = "cursor:default;user-select:none;marginTop:5px";
      option1.style.cssText =
        "cursor:default;margin:0 20px;user-select:none;display:inline-block";
      option2.style.cssText =
        "cursor:default;margin:0 20px;user-select:none;display:inline-block";
      option3.style.cssText =
        "cursor:default;margin:0 20px 0 10px;user-select:none;display:inline-block";
      option4.style.cssText =
        "cursor:default;margin:0 100px 0 10px;user-select:none;display:inline-block";
      option5.style.cssText =
        "cursor:default;margin:0 20px;user-select:none;display:inline-block";
      option6.style.cssText =
        "cursor:default;margin:0 20px;user-select:none;display:inline-block";
      this.textareaT();

      // select的改变事件
      this.select.onchange = () => {
        this.selectValue = this.select.value;
        this.textarea.style.fontFamily = this.select.value;
      };

      //进入编辑状态时把文字样式传给文本域内的字体
      this.textarea.style.fontSize = this.textFont + "px";
      //把前一步的颜色传递进来
      document.getElementById("color-picker").style.background = this.textColor;
      this.textarea.style.color = this.textColor;

      //文本域右击事件
      this.textarea.oncontextmenu = (event) => {
        event.stopPropagation();
        event.preventDefault();
      };

      // 阻止点击文字时出现冒泡事件
      this.optArr = document.getElementsByClassName("opt");
      for (let i = 0; i < this.optArr.length; i++) {
        this.optArr[i].onmousedown = (event) => {
          event.stopPropagation();
          this.OnToolbarDraw = true;
        };
        this.optArr[i].style.position = "relative";
      }

      //调用拾色器
      this.colorful();

      //按下菜单区域
      this.menuDiv.onmousedown = () => {
        //当点击事件发生后给父类里面发送信号
        this.OnToolbarDraw = true;
      };

      //松开菜单栏区域
      this.menuDiv.onmouseup = () => {
        this.OnToolbarDraw = false;
      };

      //双击菜单栏区域阻止事件冒泡
      this.menuDiv.ondblclick = (ev) => {
        ev.stopPropagation();
      };

      //右击菜单栏区域阻止事件冒泡
      this.menuDiv.oncontextmenu = (ev) => {
        ev.preventDefault();
        ev.stopPropagation();
      };

      //文本域大小改变事件和mousemove事件
      this.textarea.onmousedown=(e)=>{
        e.stopPropagation();
       if(e.pageX>(this.XY.X+this.WH.W-15)&&e.pageY>(this.XY.Y+this.WH.H-15)){ 
        this.textarea.onmousemove = () => {
          this.textareaT();
        }
        this.textarea.onmouseup=()=>{
          this.RcordTransform("resize");
          this.textarea.onmousemove=null;
        }
       }
      }
      //文本域失焦事件
      this.textarea.onblur = () => {
        //清除菜单  此刻处于非编辑状态
        console.log(this.OnToolbarDraw)
        if (!this.OnToolbarDraw) {
         
          this.ExitEdit();
        }
      };

      //文本域内部双击鼠标事件 解决重复创建文本域内的内容
      this.textarea.ondblclick = function (event) {
        event.stopPropagation();
      };
    };
  }
  //调色板
  colorful() {
    Colorpicker.create({
      el: "color-picker",
      color: this.textColor,
      // initColor: this.textColor,
      change: (elem, hex) => {
        this.textColor = hex;
        elem.style.backgroundColor = hex;
        this.DivSon.style.color = hex;
        this.textarea.style.color = hex;
      },
    });
  }
  // 文字淡入函数
textFadeIn(){
//文字显示速度(字幕速度)
if(this.txttimer){
  clearInterval(this.txttimer);
}
let i = 0;
this.txttimer = setInterval(() => {
  if (i < this.content.length) {
    this.DivSon.innerText =
      this.content.substring(0, i + 1) + (this.flag ? "|" : "");
    i = i + 1;
  } else {
    clearInterval(this.txttimer);
    this.txttimer = false;
    this.DivSon.innerText="";
  }
}, this.textSpeed);
//光标闪烁速度(光标速度)
if (this.cursorSpeed == 0) {
  this.flag = false;
} else {
  if(this.pointertimer)clearInterval(this.pointertimer);
  this.pointertimer = setInterval(() => {
    if (this.content !== "") {
      this.flag = !this.flag;
      if (!this.txttimer) {
        this.DivSon.innerText = this.content + (this.flag ? "|" : "");
      }
    }
  }, this.cursorSpeed);
}
  }
//退出编辑
ExitEdit() {
  this.DivSon.style.fontFamily = this.selectValue;
  this.Div.style.overflow="hidden";
  if (this.textCenter) {
    this.DivSon.style.width = this.Div.style.width;
    this.DivSon.style.textAlign = "center";
  } else {
    this.DivSon.style.textAlign = "left";
  }
  //给隐藏的div颜色复原
  this.DivSon.style.display = "block";
  WZCContorller.editState = false; //非编辑状态 阻止mousemove事件的冒泡

  if (this.editing) {
    //移除this.menuDiv
    removeElement(document.getElementById("menu"));
    removeElement(document.getElementById("menu"));
  }
  this.content = this.textarea.value;
  this.RcordTransform("caption");//添加字幕信息记录
  console.log(WZCContorller.History);
  this.textarea.remove();
  this.textFadeIn();
}
  //文本域形成T字形
  textareaT(WH) {
    this.DivSon.style.width = this.Div.style.width; //解决文本居中
    if(WH){
      this.textarea.style.width=WH.W+"px";
      this.textarea.style.height=WH.H+"px";
    }
    this.Div.style.width = this.textarea.style.width;
    this.Div.style.height = this.textarea.style.height;
    this.WH.W = Number(this.textarea.style.width.split("px")[0]);
    this.WH.H = Number(this.textarea.style.height.split("px")[0]);
    this.menuDiv.style.width = this.textarea.style.width;
    this.distance = 0;
    //当文本域的宽度小于菜单栏的宽度时 形成 T 字形
    if (this.textarea.offsetWidth < 980) {
      this.menuDiv.style.minWidth = "980px";
      this.distance =
        (this.menuDiv.clientWidth - this.textarea.clientWidth) / 2;
      this.menuDiv.style.marginLeft = -this.distance + "px";
      //让Div的颜色消失
      // this.Div.style.background = 'none';
      this.DivSon.style.display = "none";
    } else {
      this.menuDiv.style.textAlign = "center";
      this.DivSon.style.display = "block";
      this.distance =
        (this.menuDiv.clientWidth - this.textarea.clientWidth) / 2;
      this.menuDiv.style.marginLeft = this.distance + "px";
    }
  }
}

//音相类部分
class Voicer extends ClassPhenomena {
  constructor(
    Id,
    XY,
    WH,
    Opacity,
    BgUrl,
    BgColor,
    Curtain,
    Radius,
    fullscreen,
    OnToolbarDraw
  ) {
    super(
      Id,
      XY,
      WH,
      Opacity,
      BgUrl,
      BgColor,
      Curtain,
      Radius,
      fullscreen,
      OnToolbarDraw
    );
    this.flag = true;
    let menuTimer;
    this.editing = false;
    this.URLInp = "";
    this.url = "";
    this.ShowAudio(this.url);
    this.Div.style.minWidth = "280px";
    this.Div.style.minHeight = "120px";
    //双击div开始进入编辑状态
    // -----------进入编辑状态------------ //
    this.Div.ondblclick = (e) => {
      if(this.editing){
        return;
      }
      this.Div.style.overflow="visible";
      this.editing = true;
      if (WZCContorller.editState) {
        WZCContorller.editState.ExitEdit(e);
      }
      WZCContorller.editState = this; // 状态判断  上一个是否创建
      var formOjb = document.createElement("form");
      formOjb.id = "mediaFileStore";
      formOjb.style.display = "none";
      this.Div.appendChild(formOjb);
      //  ------------------创建菜单------------------- //
      this.menuDiv = document.createElement("div");
      this.menuDiv.id = "Au_menu";
      this.menuDiv.className = "menuDiv";
      this.menuDiv.style.width = this.Div.offsetWidth + "px";
      this.menuDiv.style.width = "50px";
      //----------------创建菜单子选项 并且添加至菜单中  菜单添加至div中--------------//
      const option1 = document.createElement("span"); //音频类型
      const URLspan = document.createElement("span"); //Url链接地址
      const InpDiv = document.createElement("div"); //放置file型上传按钮
      const option3 = document.createElement("input"); //上传音乐
      this.InpDiv = InpDiv;
      InpDiv.style.width = "70px";
      InpDiv.style.height = "30px";
      InpDiv.className = "Voicer_Btn";
      InpDiv.innerText = "上传音乐";
      InpDiv.appendChild(option3);
      option3.type = "file";
      option3.accept='audio/*';
      option3.id = "Audio_INP";
      option1.className = "opt";
      option1.id = "AudioSpan";
      option1.innerHTML = "音频类型";
      option1.className = "opt";
      URLspan.className = "opt";
      URLspan.id = "UrlSpan";
      this.SelctInp = option3;
      this.menuDiv.appendChild(option1);
      this.menuDiv.appendChild(URLspan);
      this.menuDiv.appendChild(InpDiv);
      this.Div.appendChild(this.menuDiv);
      this.selectDiv = document.createElement("div");
      this.select = document.createElement("select");
      const options1 = document.createElement("option");
      const options2 = document.createElement("option");
      options1.text = "直链";
      options2.text = "外链";
      options1.selected = true;
      this.select.appendChild(options1);
      this.select.appendChild(options2);
      this.selectDiv.appendChild(this.select);
      this.select.style.display = "block";
      this.select.style.marginTop = "3px";
      this.selectDiv.style.position = "absolute";
      this.selectDiv.style.top = "3px";
      this.selectDiv.style.left = "75px";
      this.selectDiv.style.display = "inline-block";
      option1.appendChild(this.selectDiv);
      // this.select.value = this.selectValue;
      URLspan.innerHTML = "链接地址:";
      const option2 = document.createElement("input"); //Url链接地址输入框
      const submitBtn = document.createElement("button"); //链接提交按钮
      this.SubBtn = submitBtn;
      submitBtn.id = "SubBtn";
      submitBtn.className = "Voicer_Btn";
      submitBtn.type = "submit";
      // submitBtn.name='提交';
      submitBtn.innerText = "提交";
      this.URLInp = option2;
      option2.id = "UrlInp";
      option2.type = "text";
      option2.name = "URL地址";
      option2.value = "";
      URLspan.appendChild(option2);
      URLspan.appendChild(this.SubBtn);
      const FinishBtn = document.createElement("button"); //完成编辑按钮
      FinishBtn.type = "submit";
      FinishBtn.innerText = "完成";
      FinishBtn.className = "Voicer_Btn";
      this.FinishBtn = FinishBtn;
      this.menuDiv.appendChild(this.FinishBtn);
      let DragDiv = document.createElement("div");
      this.DragDiv=DragDiv;
      DragDiv.id = "DragDiv";
      DragDiv.classList="iconfont iDrag";
      DragDiv.style.width = "25px";
      DragDiv.style.height = "25px";
      DragDiv.style.borderRadius = "50%"; //圆角百分比
      DragDiv.style.position = "absolute";
      DragDiv.style.backgroundColor = "rgb(235 239 242 / 80%)";
      DragDiv.style.boxShadow = "0px 0px 5px #88c8888";
      DragDiv.style.left = this.Div.offsetWidth + "px";
      DragDiv.style.top = this.Div.offsetHeight + "px";
      DragDiv.style.transform = "translate(-50%, -50%)";
      DragDiv.style.cursor='nw-resize';
      //为上传音乐按钮绑定一个点击事件
      this.InpDiv.onclick = function (n) {
        n.stopPropagation();
        Audio_INP.click();
      };
      this.InpDiv.onmousemove=function(evnt){
       evnt.stopPropagation();
      }
      Audio_INP.onchange = (file) => {
        φ("#mediaFileStore").append(file.target.files[0]);
        var url = window.URL.createObjectURL(file.target.files[0]);
        // --------------------此处引入读取MP3信息的js文件--base64编码方式---------------------------------//
        var jsmediatags = window.jsmediatags;
        jsmediatags.read(file.target.files[0], {
          onSuccess: (tag) => {
            this.ap.list.add([
              {
                name: tag.tags.title,
                artist: tag.tags.artist,
                url: url,
                cover: tag.tags.picture?('data:'+tag.tags.picture.format+';base64,'+ arrayBufferToBase64(tag.tags.picture.data)):'',
                lrc: "lrc.lrc",
                theme: "#ebd0c2",
                listMaxHeight: this.Div.offsetHeight - 90 + "px",
              },
            ]);
            this.AudioDelete();
          },
          onError: (error) => {
            this.ap.list.add([
              {
                name: "音乐",
                artist: "artist",
                url: url,
                cover: "cover.jpg",
                lrc: "lrc.lrc",
                theme: "#ebd0c2",
                listMaxHeight: this.Div.offsetHeight - 90 + "px",
              },
            ]);
            this.AudioDelete();
          },
        });
        //---------------------------------------------------------------------//
        φ(".aplayer-body").onload = function () {
          window.URL.revokeObjectURL(src);
        };
      };
      //为音相域右下角的圆形的拖拽div，绑定一个鼠标下压事件
      this.Div.appendChild(DragDiv);
      DragDiv.onmousedown = (e) => {
        e.stopPropagation();
        // this.RcordTransform("resize");
        document.onmousemove = (event) => {
          if (
            event.pageX - this.XY.X < 280 &&
            this.WH.W > event.pageX - this.XY.X
          ) {
            //若当前Div设置的新值宽度小于280且Div的当前宽大于鼠标移动的新值，退出程序
            return;
          }
          if (
            event.pageY - this.XY.Y < 120 &&
            this.WH.H > event.pageY - this.XY.Y
          ) {
            //若当前Div设置的新值高度小于280且Div的当前高大于鼠标移动的新值，退出程序
            return;
          }
          this.DrawDiv_WH(event, this.XY);
          if(this.ap){
            this.Div.φ('.aplayer-list').style.maxHeight= this.Div.offsetHeight - 90 + "px";
          }
          this.APlayerDivT();
        };
        document.onmouseup=(e)=>{
          e.stopPropagation();
          document.onmousemove=null;
          this.RcordTransform("resize");
          document.onmouseup=null;
          console.log(WZCContorller.History)
        }
      };
      option1.style.cssText =
        "cursor:default;margin:0px 55px 0 25px;;;user-select:none;display:inline-block";
      URLspan.style.cssText =
        "cursor:default;margin:0 20px;user-select:none;display:inline-block";
      option2.style.cssText =
        "cursor:default;margin:0 10px;padding: 0px 3px;height:20px;display:inline-block";
      submitBtn.style.cssText =
        "cursor:default;margin:0 10px;display:inline-block;width:50px;Height:30px";
      option3.style.cssText = "display:none";
      InpDiv.style.cssText =
        "cursor:default;margin:0 10px 0 10px;width:70px;user-select:none;display:inline-block";
      FinishBtn.style.cssText =
        "cursor:default;margin:0px 10px;display:inline-block;width:50px;Height:30px";
      this.APlayerDivT();//初始化T字菜单
      this.SubBtn.onclick = (e) => {
        this.urlVal = this.URLInp.value;
        if (this.select.value === "直链") {
          this.ap.list.add([
            {
              name: "音乐",
              artist: "artist",
              url: this.urlVal,
              cover: "cover.jpg",
              lrc: "lrc.lrc",
              theme: "#ebd0c2"
            },
          ]);
          this.AudioDelete();
          e.stopPropagation();
        } else {
          this.IframeAudio(this.urlVal);
        }
      };
      // select的改变事件
      this.select.onchange = (e) => {
        var str = this.select.value;
        switch (str) {
          case "直链":
            this.ShowAudio(this.urlVal);
            break;
          case "外链":
            // console.log(this.urlVal);
            this.IframeAudio(this.urlVal);
            break;
        }
      };
   
      // 阻止点击文字时出现冒泡事件
      this.optArr = document.getElementsByClassName("opt");
      for (let i = 0; i < this.optArr.length; i++) {
        this.optArr[i].onmousedown = (event) => {
          event.stopPropagation();
          this.OnToolbarDraw = true;
        };
        this.optArr[i].style.position = "relative";
      }
      //按下菜单区域
      this.menuDiv.onmousedown = () => {
        //当点击事件发生后给父类里面发送信号
        this.OnToolbarDraw = true;
      };

      //松开菜单栏区域
      this.menuDiv.onmouseup = () => {
        this.OnToolbarDraw = false;
      };

      //双击菜单栏区域阻止事件冒泡
      this.menuDiv.ondblclick = (ev) => {
        ev.stopPropagation();
      };
      //右击菜单栏区域阻止事件冒泡
      this.menuDiv.oncontextmenu = (ev) => {
        ev.preventDefault();
        ev.stopPropagation();
      };
      //音相域完成，退出编辑状态
      this.FinishBtn.onmousedown = (e) => {
        //清除菜单  此刻处于非编辑状态
        e.stopPropagation();
        if (!this.OnToolbarDraw) {
          this.ExitEdit();
        }
      };
    };
  }
  //扩展父类的sync_XY()同步坐标XY的方法
  Sync_XY(XY){
    super.Sync_XY(XY);
    console.log("233333")
    console.log(this.AudioWrapper)
    if(this.AudioWrapper){
      this.AudioWrapper.style.left=this.XY.X+"px";
      this.AudioWrapper.style.top=this.XY.Y+"px";
      };
  }
  // 删除音乐列表中的歌
  AudioDelete() {
    let audioList = this.Div.querySelectorAll("li");
    for (let i = 0; i < audioList.length; i++) {
      var element = audioList[i];
      element.oncontextmenu = (evn) => {
        evn.stopPropagation();
        evn.preventDefault();
        this.ap.list.remove(i);
        this.AudioDelete();
      };
    }
  }
  //退出编辑
  ExitEdit() {
    this.Div.style.overflow="hidden";
    WZCContorller.editState = false; //非编辑状态阻止mousemove事件的冒泡
    if (this.editing) {
      //移除this.menuDiv
      removeElement(document.getElementById("Au_menu"));
      removeElement(document.getElementById("DragDiv"));
    }
    this.editing=false;
  }
  //音相域形成T字形
  APlayerDivT() {
    if(this.AudioWrapper){
      this.AudioWrapper.style.width= this.WH.W+'px';
      this.AudioWrapper.style.height= this.WH.H+'px';
    }
    if(this.VideoWrapper){
      this.VideoWrapper.style.width= this.WH.W+'px';
      this.VideoWrapper.style.height= this.WH.H+'px';
    }
    this.DragDiv.style.left = this.WH.W + "px";
    this.DragDiv.style.top = this.WH.H + "px";
    this.Div.style.width=this.WH.W+"px";
    this.Div.style.height=this.WH.H+"px";
    this.menuDiv.style.width = this.Div.style.width;
    this.distance = 0;
    //当文本域的宽度小于菜单栏的宽度时 形成 T 字形
    if (this.Div.offsetWidth < 690) {
      this.menuDiv.style.minWidth = "690px";
      this.distance = (this.menuDiv.clientWidth - this.Div.clientWidth) / 2;
      this.menuDiv.style.marginLeft = -this.distance + "px";
    } else {
      this.menuDiv.style.textAlign = "center";
      this.Div.style.display = "block";
      this.distance = (this.menuDiv.clientWidth - this.Div.clientWidth) / 2;
      this.menuDiv.style.marginLeft = this.distance + "px";
    }
  }
  // 选择直链时对应显示Audio组件；并删除AplayerDiv内部的ifram元素
  ShowAudio(url) {
    if(this.InpDiv){
      this.InpDiv.style.display="inline-block";
    }
    if (this.New_Iframe) {
      removeElement(this.New_Iframe);
      removeElement(this.AudioWrapper);
      this.New_Iframe='';
    }
    this.Div.style.backgroundColor= this.Div.BgColor;
    this.ap = new APlayer({
      container: this.Div,
      mini: false,
      autoplay: true,
      theme: "#FADFA3",
      loop: "all",
      order: "random",
      preload: "auto",
      volume: 0.5,
      mutex: true,
      listFolded: true,
      listMaxHeight: this.Div.offsetHeight - 90 + "px",
      lrcType: 3,
      audio: [
        {
          name: "Higher",
          artist: "Erik Gronwall",
          url: this.url || "./mp3/Higher.mp3",
          // url: 'http://music.163.com/song/media/outer/url?id=454828887.mp3'|| url,
          cover: "./img/Higher.jpg",
        },
      ],
    });
    //把音乐的body和list阻止onmousedown事件
    if(this.Div.querySelector(".aplayer-body")){
      this.Div.querySelector(".aplayer-body").onmousedown = (e) => {
        e.stopPropagation();
      }
      this.Div.querySelector(".aplayer-list").onmousedown = (e) => {
        e.stopPropagation();
      }
    }
    if(this.menuDiv){
      this.Div.appendChild(this.menuDiv);
      this.Div.appendChild(this.DragDiv);
    }
  }
  IframeAudio(url) {
    this.InpDiv.style.display="none";//上传按键不显示
    if(this.ap){
      this.ap.list.clear();
    }
    this.ap=null;
    removeElement(this.Div.querySelector(".aplayer-body"));
    removeElement(this.Div.querySelector(".aplayer-list"));
    // this.ap.destroy();
    if (this.New_Iframe) {
      document.getElementById("IframeAu").src = url;
    } else {
      this.New_Iframe = document.createElement("iframe");
      this.New_Iframe.id = "IframeAu";
      this.New_Iframe.style.width = "100%";
      this.New_Iframe.style.height = "100%";
      this.New_Iframe.src = url || "https://kf369.cn/music/";
      this.New_Iframe.style.frameborder = "0";
      this.AudioWrapper=document.createElement("div");
      this.AudioWrapper.style.width=this.WH.W+"px";
      this.AudioWrapper.style.height=this.WH.H+"px";
      this.AudioWrapper.style.position="absolute";
      this.AudioWrapper.style.left=this.XY.X+"px";
      this.AudioWrapper.style.top=this.XY.Y+"px";
      this.Div.style.backgroundColor="transparent";
      this.AudioWrapper.style.zIndex='-1';
      this.AudioWrapper.appendChild(this.New_Iframe);
      document.body.appendChild(this.AudioWrapper);
    }
  }
}
//视相类部分
class Vision extends ClassPhenomena {
  constructor(
    Id,
    XY,
    WH,
    Opacity,
    BgUrl,
    BgColor,
    Curtain,
    Radius,
    fullscreen,
    OnToolbarDraw
  ) {
    super(
      Id,
      XY,
      WH,
      Opacity,
      BgUrl,
      BgColor,
      Curtain,
      Radius,
      fullscreen,
      OnToolbarDraw
    );
    this.flag = true;
    let menuTimer;
    this.editing = false;
    this.URLInp = "";
    this.url = "";
    
    this.ShowVideo(this.url);
    //双击div开始进入编辑状态
    // -----------进入编辑状态------------ //
    this.Div.ondblclick = (e) => {
      if(this.editing){
        return;
      }
      this.editing = true;
      this.Div.style.overflow="visible";
      if (WZCContorller.editState) {
        WZCContorller.editState.ExitEdit(e);
      }
      WZCContorller.editState = this; // 状态判断上一个是否创建
      //在文本域中让创建div事件失效以及重复进入时,定时器失效用-->
      clearInterval(this.flags);
      clearInterval(menuTimer);
      var formOjb = document.createElement("form");
      formOjb.id = "mediaFileStore";
      formOjb.style.display = "none";
      this.Div.appendChild(formOjb);
      //  ------------------创建菜单------------------- //
      this.menuDiv = document.createElement("div");
      this.menuDiv.id = "Au_menu";
      this.menuDiv.className = "menuDiv";
      this.menuDiv.style.width = this.VideoDiv.offsetWidth + "px";
      this.menuDiv.style.width = "50px";
      //----------------创建菜单子选项 并且添加至菜单中  菜单添加至div中--------------//
      const option1 = document.createElement("span"); //视频类型
      const URLspan = document.createElement("span"); //Url链接地址
      const InpDiv = document.createElement("div"); //放置file型上传按钮
      const option3 = document.createElement("input"); //上传视频
      this.InpDiv = InpDiv;
      InpDiv.style.width = "70px";
      InpDiv.style.height = "30px";
      InpDiv.className = "Voicer_Btn";
      InpDiv.innerText = "上传视频";
      InpDiv.appendChild(option3);
      option3.type = "file";
      option3.accept='video/*';
      option3.id = "Video_INP";
      option1.className = "opt";
      option1.id = "VideoSpan";
      option1.innerHTML = "视频类型";
      option1.className = "opt";
      URLspan.className = "opt";
      URLspan.id = "UrlSpan";
      this.SelctInp = option3;
      this.menuDiv.appendChild(option1);
      this.menuDiv.appendChild(URLspan);
      this.menuDiv.appendChild(InpDiv);
      this.Div.appendChild(this.menuDiv);
      this.selectDiv = document.createElement("div");
      this.select = document.createElement("select");
      const options1 = document.createElement("option");
      const options2 = document.createElement("option");
      options1.text = "直链";
      options2.text = "外链";
      options1.selected = true;
      this.select.appendChild(options1);
      this.select.appendChild(options2);
      this.selectDiv.appendChild(this.select);
      this.select.style.display = "block";
      this.select.style.marginTop = "3px";
      this.selectDiv.style.position = "absolute";
      this.selectDiv.style.top = "3px";
      this.selectDiv.style.left = "75px";
      this.selectDiv.style.display = "inline-block";
      option1.appendChild(this.selectDiv);
      URLspan.innerHTML = "链接地址:";
      const option2 = document.createElement("input"); //Url链接地址输入框
      const submitBtn = document.createElement("button"); //链接提交按钮
      this.SubBtn = submitBtn;
      submitBtn.id = "SubBtn";
      submitBtn.className = "Voicer_Btn";
      submitBtn.type = "submit";
      submitBtn.innerText = "提交";
      this.URLInp = option2;
      option2.id = "UrlInp";
      option2.type = "text";
      option2.name = "URL地址";
      option2.value = "";
      URLspan.appendChild(option2);
      URLspan.appendChild(this.SubBtn);
      const FinishBtn = document.createElement("button"); //完成编辑按钮
      FinishBtn.type = "submit";
      FinishBtn.innerText = "完成";
      FinishBtn.className = "Voicer_Btn";
      this.FinishBtn = FinishBtn;
      this.menuDiv.appendChild(this.FinishBtn);
      let DragDiv = document.createElement("div");
      this.DragDiv=DragDiv;
      DragDiv.id = "DragDiv";
      DragDiv.classList="iconfont iDrag";
      DragDiv.style.width = "25px";
      DragDiv.style.height = "25px";
      DragDiv.style.borderRadius = "50%"; //圆角百分比
      DragDiv.style.position = "absolute";
      DragDiv.style.zIndex='999';
      DragDiv.style.backgroundColor = "rgb(235 239 242 / 80%)";
      DragDiv.style.boxShadow = "0px 0px 5px #88c8888";
      DragDiv.style.left = this.Div.offsetWidth + "px";
      DragDiv.style.top = this.Div.offsetHeight + "px";
      DragDiv.style.transform = "translate(-50%, -50%)";
      DragDiv.style.cursor='nw-resize';
      //为上传视频按钮绑定一个点击事件
      this.InpDiv.onclick = function (n){
        n.stopPropagation();
        Video_INP.click();
      };
      this.InpDiv.onmousemove=function(evn){
       evn.stopPropagation();
      }
      Video_INP.onchange = (file) => {
        φ("#mediaFileStore").append(file.target.files[0]);
        var url = window.URL.createObjectURL(file.target.files[0]);
        // --------------------此处引用读取MP4缩略图封面的方法---------------------------------//
        getVideoPreviewImg(url,this.VideoDiv.offsetWidth,this.Div.offsetHeight).then(res=>{
          /* 缩略图的base64数据 */
          this.dp.switchVideo(
            {
                url: url,
                pic: res,
                thumbnails: 'second.jpg',
            },
            {
                id: 'test',
                api: 'https://api.prprpr.me/dplayer/',
                maximum: 3000,
                user: 'DIYgod',
            }
        );
            console.log(res)
          }) 
        //---------------------------------------------------------------------//
        φ(".VideoDiv").onload = function () {
          window.URL.revokeObjectURL(src);
        };
      };
      //为视相域右下角的圆形的拖拽div，绑定一个鼠标下压事件
      this.Div.appendChild(DragDiv);
      DragDiv.onmousedown = (e) => {
        e.stopPropagation();
        document.onmousemove = (event) => {
          if (
            event.pageX - this.XY.X < 280 && this.WH.W > event.pageX - this.XY.X
          ) {
            //若当前Div设置的新值宽度小于280且Div的当前宽大于鼠标移动的新值，退出程序
            return;
          }
          if (
            event.pageY - this.XY.Y < 120 && this.WH.H > event.pageY - this.XY.Y
          ) {
            //若当前Div设置的新值高度小于280且Div的当前高大于鼠标移动的新值，退出程序
            return;
          }
          this.DrawDiv_WH(event, this.XY);
          this.DPlayerDivT();
        };
        document.onmouseup=(e)=>{//document、window是全局变量，避免事件替换；解决方法就是阻止冒泡后，将onmousemove事件和onmouseup事件都置空
            e.stopPropagation();
            document.onmousemove=null;
            this.RcordTransform("resize");//记录大小改变
            document.onmouseup=null;
            console.log(WZCContorller.History)
        }
      };
      option1.style.cssText =
        "cursor:default;margin:0px 55px 0 25px;;;user-select:none;display:inline-block";
      URLspan.style.cssText =
        "cursor:default;margin:0 20px;user-select:none;display:inline-block";
      option2.style.cssText =
        "cursor:default;margin:0 10px;padding: 0px 3px;height:20px;display:inline-block";
      submitBtn.style.cssText =
        "cursor:default;margin:0 10px;display:inline-block;width:50px;Height:30px";
      option3.style.cssText = "display:none";
      InpDiv.style.cssText =
        "cursor:default;margin:0 10px 0 10px;width:70px;user-select:none;display:inline-block";
      FinishBtn.style.cssText =
        "cursor:default;margin:0px 10px;display:inline-block;width:50px;Height:30px";
      this.DPlayerDivT();
      this.SubBtn.onclick = (e) => {
        this.urlVal = this.URLInp.value;
        if (this.select.value === "直链") {
          this.dp.switchVideo(
            {
                url: this.urlVal,
                pic: 'second.png',
                thumbnails: 'second.jpg',
            },
            {
                id: 'test',
                api: 'https://api.prprpr.me/dplayer/',
                maximum: 3000,
                user: 'DIYgod',
            }
        );
          e.stopPropagation();
        } else {
          this.IframeVideo(this.urlVal);
        }
      };
      // select的改变事件
      this.select.onchange = (e) => {
        var str = this.select.value;
        switch (str) {
          case "直链":
            this.ShowVideo(this.urlVal);
            break;
          case "外链":
            // console.log(this.urlVal);
            this.IframeVideo(this.urlVal);
            break;
        }
      };
      // 阻止点击文字时出现冒泡事件
      this.optArr = document.getElementsByClassName("opt");
      for (let i = 0; i < this.optArr.length; i++) {
        this.optArr[i].onmousedown = (event) => {
          event.stopPropagation();
          this.OnToolbarDraw = true;
        };
        this.optArr[i].style.position = "relative";
      }
      //按下菜单区域
      this.menuDiv.onmousedown = () => {
        //当点击事件发生后给父类里面发送信号
        this.OnToolbarDraw = true;
      };

      //松开菜单栏区域
      this.menuDiv.onmouseup = () => {
        this.OnToolbarDraw = false;
      };

      //双击菜单栏区域阻止事件冒泡
      this.menuDiv.ondblclick = (ev) => {
        ev.stopPropagation();
      };
      //右击菜单栏区域阻止事件冒泡
      this.menuDiv.oncontextmenu = (ev) => {
        ev.preventDefault();
        ev.stopPropagation();
      };
      //视相域完成，退出编辑状态
      this.FinishBtn.onmousedown = (e) => {
        //清除菜单  此刻处于非编辑状态
        e.stopPropagation();
        if (!this.OnToolbarDraw) {
          this.ExitEdit();
        }
      };

    };
  }
   //扩展父类的sync_XY()的方法
   Sync_XY(XY){
    super.Sync_XY(XY);
        if(this.VideoWrapper){
          this.VideoWrapper.style.left=this.XY.X+"px";
          this.VideoWrapper.style.top=this.XY.Y+"px";
          }
    }
  //退出编辑
  ExitEdit() {
    this.Div.style.overflow="hidden";
    WZCContorller.editState = false; //非编辑状态阻止mousemove事件的冒泡
    if (this.editing) {
      //移除this.menuDiv
      removeElement(document.getElementById("Au_menu"));
      removeElement(document.getElementById("DragDiv"));
    }
    this.editing=false;
  }
  //视相域形成T字形
  DPlayerDivT() {
    if(this.AudioWrapper){
      this.AudioWrapper.style.width= this.WH.W+'px';
      this.AudioWrapper.style.height= this.WH.H+'px';
    }
    if(this.VideoWrapper){
      this.VideoWrapper.style.width= this.WH.W+'px';
      this.VideoWrapper.style.height= this.WH.H+'px';
    }
    this.DragDiv.style.left = this.WH.W + "px";
    this.DragDiv.style.top = this.WH.H + "px";
    this.Div.style.width=this.WH.W+"px";
    this.Div.style.height=this.WH.H+"px";
    this.VideoDiv.style.width =this.Div.offsetWidth+"px";
    this.VideoDiv.style.height=this.Div.offsetHeight+"px";
    this.menuDiv.style.width = this.Div.style.width;
    this.distance = 0;
    //当文本域的宽度小于菜单栏的宽度时 形成 T 字形
    if (this.Div.offsetWidth < 690) {
      this.menuDiv.style.minWidth = "690px";
      this.distance = (this.menuDiv.clientWidth - this.Div.clientWidth) / 2;
      this.menuDiv.style.marginLeft = -this.distance + "px";
    } else {
      this.menuDiv.style.textAlign = "center";
      this.Div.style.display = "block";
      this.distance = (this.menuDiv.clientWidth - this.Div.clientWidth) / 2;
      this.menuDiv.style.marginLeft = this.distance + "px";
    }
  }
  // 选择直链时对应显示Video组件；并删除AplayerDiv内部的ifram元素
  ShowVideo(url) {
    this.VideoDiv = document.createElement("div");
    this.VideoDiv.className = "VideoDiv";
    this.VideoDiv.id="VideoDiv";
    this.VideoDiv.style.width =this.Div.offsetWidth+"px";
    this.VideoDiv.style.height=this.Div.offsetHeight+"px";
    this.Div.appendChild(this.VideoDiv);
    if(this.InpDiv){
      this.InpDiv.style.display="inline-block";
    }
    if (this.New_Iframe) {
      removeElement(this.New_Iframe);
      removeElement(this.VideoWrapper);
      this.New_Iframe='';
    }
    // this.Div.style.backgroundColor= this.Div.BgColor;
    this.dp = new DPlayer({
      container:this.VideoDiv,
      autoplay: false,
      theme: '#FADFA3',
      loop: true,
      lang: 'zh-cn',
      screenshot: true,
      hotkey: true,
      preload: 'auto',
      logo: './img/logo.png',
      volume: 0.5,
      mutex: true,
      video: {
          url: url||'https://api.dogecloud.com/player/get.mp4?vcode=5ac682e6f8231991&userId=17&ext=.mp4',
          pic: 'dplayer.png',
          thumbnails: 'thumbnails.jpg',
          type: 'auto',
      },
      subtitle: {
          url: 'dplayer.vtt',
          type: 'webvtt',
          fontSize: '25px',
          bottom: '10%',
          color: '#b7daff',
      },
      danmaku: {
          id: '9E2E3368B56CDBB4',
          api: 'https://api.prprpr.me/dplayer/',
          token: 'tokendemo',
          maximum: 1000,
          addition: ['https://api.prprpr.me/dplayer/v3/bilibili?aid=4157142'],
          user: 'DIYgod',
          bottom: '15%',
          unlimited: true,
      },
      highlight: [
          {
              time: 20,
              text: '这是第 20 秒',
          },
          {
              time: 120,
              text: '这是 2 分钟',
          },
      ],
  });
  this.Div.φ('.dplayer-controller').onmousedown=(e)=>{
      e.stopPropagation();
  }
  }
  IframeVideo(url) {
    this.InpDiv.style.display="none";
    this.dp=null;
    removeElement(this.Div.querySelector(".VideoDiv"));
    if (this.New_Iframe) {
      document.getElementById("IframeAu").src = url;
    } else {
      this.New_Iframe = document.createElement("iframe");
      this.New_Iframe.id = "IframeAu";
      this.New_Iframe.style.width = "100%";
      this.New_Iframe.style.height = "100%";
      this.New_Iframe.src = url || "https://kf369.cn/music/";
      this.New_Iframe.style.frameborder = "0";
      this.VideoWrapper=document.createElement("div");
      this.VideoWrapper.style.width=this.WH.W+"px";
      this.VideoWrapper.style.height=this.WH.H+"px";
      this.VideoWrapper.style.position="absolute";
      this.VideoWrapper.style.left=this.XY.X+"px";
      this.VideoWrapper.style.top=this.XY.Y+"px";
      this.Div.style.backgroundColor="transparent";
      this.VideoWrapper.style.zIndex='-1';
      this.VideoWrapper.appendChild(this.New_Iframe);
      document.body.appendChild(this.VideoWrapper);
    }
  }
}
//文本滑块组
class textSlider {
  constructor(iptVal, father) {
    //字体大小模块设计(文本框 + 滑块 + px)
    this.textInput = document.createElement("input");
    this.textInput.type = "text";
    this.textInput.className = "inputText";
    this.slider = document.createElement("input");
    this.slider.className = "sliderDemo";
    this.slider.type = "range";
    this.slider.min = "0";
    this.slider.max = "1000";
    this.visible = false;
    //字体大小的方法
    this.sliderInputFuc = null;
    this.textInputFuc = null;
    father.appendChild(this.textInput);
    father.appendChild(this.slider);
    this.textInput.value = iptVal;
    this.slider.value = iptVal;
    this.slider.style.background =
      "linear-gradient(to right, #059CFA, white " +
      this.slider.value / 10 +
      "%, white)";
    this.slider.oninput = () => {
      this.slider.style.background =
        "linear-gradient(to right, #059CFA, white " +  this.slider.value / 10 +"%, white)";
      this.textInput.value = this.slider.value;   
      if (this.sliderInputFuc) {
        this.sliderInputFuc(this);
      }
    };
    this.slider.onmousedown = (event) => {
      event.stopPropagation();
      this.visible = true;
    };
    this.slider.onmouseup = () => {
      this.visible = false;
      this.textInput.focus();
    };
    this.textInput.oninput = (e) => {
      this.textInput.value = this.textInput.value.replace(/\D/g, "");
      this.slider.value = this.textInput.value;
      if (this.sliderInputFuc) {
        this.sliderInputFuc(this);
      }
    };
    this.textInput.onfocus = () => {
      this.visible = false;
      this.slider.style.display = "inline-block";
    };
    this.textInput.onblur = () => {
      if (this.visible) {
        this.slider.style.display = "block";
      } else {
        this.slider.style.display = "none";
      }
    };
    this.textInput.onmousedown = (event) => {
      if (this.textInputFuc) this.textInputFuc(this);
      event.stopPropagation();
    };
  }
}